#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Tumbling SquaresMod01.fsh   by   104  
//https://www.shadertoy.com/view/wlfXzj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


// boilerplate ======================
const float PI = 3.14159;
const float PI2 = PI*2.;

vec3 dtoa(float d, vec3 amount){
    return vec3(1. / clamp(d*amount, vec3(1), amount));
}
mat2 rot2D(float r){
    return mat2(cos(r), sin(r), -sin(r), cos(r));
}
float nsin(float x) {
    return cos(x)*.5+.5;
}
vec3 hash32(vec2 p) {
	vec3 p3 = fract(vec3(p.xyx) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yxz+19.19);
    return fract((p3.xxy+p3.yzz)*p3.zyx);
}
float opUnion( float d1, float d2 ) { return min(d1,d2); }
float opSubtraction( float d1, float d2 ) { return max(-d1,d2); }
float opIntersection( float d1, float d2 ) { return max(d1,d2); }
float opXor(float lhs, float rhs) {
    return opUnion(opIntersection(lhs, -(rhs)), opIntersection(rhs, -(lhs)));
}

float sdSquare(vec2 p, vec2 center, float s) {
	vec2 d = abs(p-center) - s;
	return min(max(d.x, d.y), 0.0) + length(max(d, 0.0));
}
// end boilerplate ======================

const float th = 1./3.;
float hello(float sd, vec2 uv, float off, float a, vec2 sgn) {
    sd = opXor(sd, sdSquare((uv + sgn*vec2(.5,.5)+vec2(-off,0)) * rot2D(a), vec2(-th*.5), th*.5));
    sd = opXor(sd, sdSquare((uv + sgn*vec2(-.5,.5)+vec2(0,-off)) * rot2D(a+PI*.5), vec2(-th*.5), th*.5));
    sd = opXor(sd, sdSquare((uv + sgn*vec2(.5,-.5)+vec2(0,off)) * rot2D(a-PI*.5), vec2(-th*.5), th*.5));
    sd = opXor(sd, sdSquare((uv + sgn*vec2(-.5,-.5)+vec2(off,0)) * rot2D(a-PI), vec2(-th*.5), th*.5));
    return sd;
}

float scurve(float x, float p) {
    x = x / p * PI2;
    return (x + sin(x+PI)) / PI2;
}
#define o fragColor
//void mainImage( out vec4 o, in vec2 fragCoord )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord/iResolution.xy-.5;
    uv.x *= iResolution.x / iResolution.y;
    
    uv *= 2.8;
    float tsteady = iTime*.25;
    float t = scurve(tsteady, th);
    float sd = 1e6;
    float sdout = 1e6;
    
    uv *= rot2D(-tsteady*PI2*.25);
    float r = .5+(sqrt(2.)*th);
    uv -= r;
    float padding = .1; // kinda important because blurriness doesn't cross cells
    uv = mod(uv, r+r+padding)-r-padding*.5; // repetition

    float seg = mod(t, 3.);
    float aout = fract(seg)*PI*.5;
    float ain = -(aout+PI*.5);
    float offout = 0.;
    float offin = th*2.;
    if (seg >= 2.) {
		aout = (fract(seg)-.5)*PI;
        ain = PI;
    } else if (seg >= 1.) {
        offout = th*2.;
    } else {
        offout = th;
        offin = th;
    }

    float tsel = mod(t/3., 3.);
    bool A = false, B = false, C = false, D = false;
    
    if (tsel >= 2.) {
    	// (none)
    } else if (tsel >= 1.) {
    	// (big plus)
        A = B = true;
    } else {
    	// (minimal + outline)
        B = C = D = true;
    }
    
    if (A) sd = sdSquare(uv, vec2(0),.5);
   	if (B) sd = opXor(sd, sdSquare(uv, vec2(0),r));
   	if (C) sd = opXor(sd, sdSquare(uv, vec2(0),r));
    if (D) sd = hello(sd, uv, offout, aout, vec2(1));
    
    sdout = hello(sdout, uv, offout, aout, vec2(1));
    sd = hello(sd, uv, offout, aout, vec2(1));
    sd = hello(sd, uv, offin, ain, vec2(1));

    o.rgb = dtoa(sd, 3.*vec3(50.,100.,200.)) * vec3(.9,.9,.8);
    o.rgb += dtoa(sdout, 2.*vec3(100.,50.,50.)) * vec3(.1,-.8,.4);
    
    vec2 N = fragCoord / iResolution.xy-.5;

    o.rgb += (hash32(fragCoord+t)-.5)*.1;
    o.rgb += dot(N,N) * vec3(.2,.5,1);
    o = clamp(o,o-o,o-o+1.);
    fragColor *= 1.-length(9.*pow(abs(N), vec2(3.)));// vingette
    fragColor.a = 1.;

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

